﻿using System;

namespace CSharpBuch.Kap14
{
  class NoArgsException : ApplicationException
  {
    public int parameterAnzahl = 0;

    public NoArgsException()
    {
    }

    public NoArgsException(string message)
      : base(message)
    {
    }

    public NoArgsException(string message, int parameterAnzahl)
      : base(message)
    {
      this.parameterAnzahl = parameterAnzahl;
    }

    public NoArgsException(string message, Exception inner)
      : base(message, inner)
    {
    }

    public NoArgsException(string message, Exception inner, int parameterAnzahl)
      : base(message, inner)
    {
      this.parameterAnzahl = parameterAnzahl;
    }

    public override string Message
    {
      get
      {
        return base.Message +
               String.Format(" :es müssen der Anwendung {0} Parameter übergeben werden.", parameterAnzahl);
      }
    }
  }
}